/*:ja
 * @plugindesc レバガチャゲージウィンドウを出します。
 * @author TRS
 *
 *
 * @param -----ウィンドウ設定-----
 * @desc セパレータ
 * @param X座標
 * @desc ウィンドウの全体座標X
 * @type number
 * @default 0
 *
 * @param Y座標
 * @desc ウィンドウの全体座標Y
 * @type number
 * @default 1
 * 
 * @param 幅
 * @desc ウィンドウ横幅
 * @type number
 * @default 200
 *
 * @param 高さ
 * @desc ウィンドウ高さ
 * @type number
 * @default 100
 *
 * @param ベース不透明度
 * @desc ベースウィンドウの不透明度
 * @type number
 * @default 0
 *
 * @param -----連打グラ設定-----
 * @desc セパレータ
 *
 * @param 連打ファイル名
 * @desc 連打グラフィックのファイル名
 * @type file
 * @require 1
 * @dir img/pictures/
 * @default 連打
 *
 * @param 連打X座標
 * @desc 連打グラフィックの横座標
 * @type number
 * @default 50
 *
 * @param 連打Y座標
 * @desc 連打グラフィックの縦座標
 * @type number
 * @default 0
 
 * @param -----レバー設定-----
 * @desc セパレータ
 *
 * @param レバー名
 * @desc レバーファイル名(複数設定　左→中→右の順)
 * @type string
 * @default レバー_左 レバー_中 レバー_右
 *
 * @param レバーX座標
 * @desc レバーの横座標
 * @type number
 * @default 0
 *
 * @param レバーY座標
 * @desc レバーの縦位置
 * @type number
 * @default 0
 *
 * @param キー連動
 * @desc 左右を押したときに連動させるか(false時は常にアニメーションします)
 * @type boolean
 * @default false
 *
 * @param 入力音
 * @desc キーを押したときに出る音
 * @type file
 * @require 1
 * @dir audio/se/
 * @default Blow1
 *
 * @param -----ゲージ設定-----
 * @desc セパレータ
 *
 * @param グラデ終端色
 * @desc グラデーション終端色
 * 初期値: #ff60c0
 * @default #ff60c0
 *
 * @param グラデ開始色
 * @desc グラデーション開始色
 * 初期値: #ffa0e0
 * @default #ffa0e0
 *
 * @param ゲージX座標
 * @desc ゲージの横位置
 * @type number
 * @default 0
 *
 * @param ゲージY座標
 * @desc ゲージの縦位置
 * @type number
 * @default 20
 *
 * @param ゲージ幅
 * @desc ゲージの横方向長さ
 * @type number 
 * @default 100
 *
 * @param -----スイッチ------
 * @desc セパレータ
 *
 * @param 完了スイッチ番号
 * @desc レバガチャ完了時にONになるスイッチ番号
 * @type switch
 * @default 220
 *
 * @param ----ピクチャ連動----
 * @desc セパレータ
 *
 * @param 立ち絵連動
 * @desc 立ち絵もレバガチャ入力時に動かす
 * ※使うときは、BattleStandIrastの下へ置いてください
 * @type boolean
 * @default true
 *
 * @param 揺れ具合
 * @desc １回で揺れる大きさ
 * @type number
 * @min 0
 * @max 50
 * @default 25
 *
*/

(function() {
	var parameters = PluginManager.parameters('LeberGage');
	
	var varWindowXpos = Number(parameters['X座標'] || 0);
	var varWindowYpos = Number(parameters['Y座標'] || 1);
	
	var varWindowWidth =  Number(parameters['幅'] || 200);
	var varWindowHeight = Number(parameters['高さ'] || 100);
	var varBaseOpacity = Number( parameters['ベース不透明度'] || 0 );
	
	var varLeberName = ( parameters['レバー名'] || 'レバー_左 レバー_中 レバー_右' ).split(' ');
	
	var varGageColor = parameters['グラデ終端色'] || '#ff60c0';
	var varGageFillColor = parameters['グラデ開始色'] || '#ffa0e0';
	
	var varLeberSwitch = Number( parameters['完了スイッチ番号'] || 0 );
	
	var varLeberOffsetX = Number( parameters['レバーX座標'] || 0 );
	var varLeberOffsetY = Number( parameters['レバーY座標'] || 0 );
	
	var varGageX = Number( parameters['ゲージX座標'] || 0 );
	var varGageY = Number( parameters['ゲージY座標'] || 20 );
	var varGageWidth = Number( parameters['ゲージ幅'] || 100 );
	
	var varShowLeberGageFlag = false;		//レバーゲージ
	var varLeverGtyaCountMax = 20;			//レバガチャカウント最大値(20はテスト用数値)
	var varLeverGtyaCount = 20;				//レバガチャ残カウント
	
	var isInterlocking = Boolean( parameters['キー連動'] || 'false' );
	
	var isPictureInterlocking = Boolean( parameters['立ち絵連動'] || 'true' );
	var varPictureShake = Number( parameters['揺れ具合'] || 25 );
	
	var varInputSe = parameters['入力音'] || 'Blow1';
	
	//連打ピクチャ
	var varRendaPicName = parameters['連打ファイル名'] || '連打';
	var varRendaPicXPos =  Number( parameters['連打X座標'] || 0 );
	var varRendaPicYPos =  Number( parameters['連打Y座標'] || 0 );
	
	//-----------------------------------------------------------------------------
	// Game_Interpreter
	//
	var _Game_Interpreter_pluginCommand = Game_Interpreter.prototype.pluginCommand;
	Game_Interpreter.prototype.pluginCommand = function(command, args) 
	{
		_Game_Interpreter_pluginCommand.call(this, command, args);
	    if (command === 'showLeberGage') 
	    {
	    	
			varShowLeberGageFlag = true;
			varLeverGtyaCountMax = Number( args[0] );
			varLeverGtyaCount =  varLeverGtyaCountMax;
			
			
	    } else if (command === 'hideLeberGage') {
			varShowLeberGageFlag = false;
	    }
	};
	
	//-----------------------------------------------------------------------------
	// Window_BattleLeberGauge
	//
	function Window_BattleLeberGauge() 
	{
		this.initialize.apply(this, arguments);
	}

	Window_BattleLeberGauge.prototype = Object.create(Window_Base.prototype);
	Window_BattleLeberGauge.prototype.constructor = Window_BattleLeberGauge;

	Window_BattleLeberGauge.prototype.initialize = function()
	{
		var x      = varWindowXpos;
		var y      = varWindowYpos;
		var width  = varWindowWidth;
		var height = varWindowHeight;
		Window_Base.prototype.initialize.call(this, x, y, width, height);
		this.openness = 255;
		this.opacity = varBaseOpacity;
		this.contentsOpacity = 255;
		
		this.LaberAnimeIndex = 0;
		this.LaberAnimeCnt = 0;
		this.oldFileName = "";
		
		this._rendaInfo = new Sprite();
		this._rendaInfo.anchor.x = 0.5;
        this._rendaInfo.anchor.y = 0.5;
        this._rendaInfo.x = varRendaPicXPos;
        this._rendaInfo.y = varRendaPicYPos;
        this._rendaAnime = 0; 
        this._rendaAnimeIndex = 0;
        
        this.addChildToBack(this._rendaInfo);
        this._rendaInfo.bitmap = ImageManager.loadPicture(varRendaPicName);
        
        this.InitialLoad();
	};
  	
  	//初期先行ロード
  	Window_BattleLeberGauge.prototype.InitialLoad = function()
  	{
  		for(var i = 0; i < 3; i++)
  		{
  			this.drawLaber(varLeberName[i]);
  		}
  		
  		//先行ロード終わったら最初のレバーを描画
  		this.drawLaber( varLeberName[1] );
  		
  		this.refresh();
  	}
  	
  	// フレーム更新
	Window_BattleLeberGauge.prototype.update = function()
	{
		Window_Base.prototype.update.call(this);
		var needRefresh = this.isNeedRefresh();
		if (needRefresh) 
		{
			this.refresh();
		}
		
		this.InputAnime();
		
		//連動ありか？
		if( isInterlocking === false)
		{
			this.LeverAnime();
		}
		else
		{
			this.drawLaberGage();
			
		}
		
		this.InputRapid();
		
		this.AnimeRendaMessage();
		
	};
	
	//連打メッセージのアニメーション
	Window_BattleLeberGauge.prototype.AnimeRendaMessage = function()
	{
		var RendaTable = [1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8, 1.9, 2.0, 1.9, 1.8, 1.7, 1.6, 1.5, 1.4, 1.3, 1.2, 1.1]; 
		if( this._rendaInfo.bitmap )
		{
			this._rendaAnimeIndex += 1;
			if( this._rendaAnimeIndex % 4 == 0)
			{
				if( this._rendaAnimeIndex < RendaTable.length )
				{
					
					this._rendaAnimeIndex += 1;
				}
				else
				{
					this._rendaAnimeIndex = 0;
				}
				
            }
            
            this._rendaInfo.scale.x = 1 * RendaTable[ this._rendaAnimeIndex ];
           	this._rendaInfo.scale.y = 1 * RendaTable[ this._rendaAnimeIndex ];
		}
	}
	
	// リフレッシュが必要かどうかを返す
	Window_BattleLeberGauge.prototype.isNeedRefresh = function()
	{
		
    	return false;
  	};
  	// リフレッシュ
	Window_BattleLeberGauge.prototype.refresh = function()
	{
		this.contents.clear();

	};
	
	//フレームアニメ
	Window_BattleLeberGauge.prototype.LeverAnime = function()
	{
		var lstLaverFilename = [varLeberName[1], varLeberName[0], varLeberName[1], varLeberName[2]];
		
		this.LaberAnimeCnt++;
		if( this.LaberAnimeCnt % 2 === 0 )
		{
			if( this.LaberAnimeIndex === 3 )
				this.LaberAnimeIndex = 0;
			else
				this.LaberAnimeIndex += 1;
			this.refresh();
		}
		
		this.drawLaber(lstLaverFilename[this.LaberAnimeIndex]);
	};
	
	//インプットアニメ
	Window_BattleLeberGauge.prototype.InputAnime = function()
	{
		var varInputFileName = varLeberName[1];
		
		if( Input.isPressed('left') )
		{
			varInputFileName = varLeberName[0];
			
		}
		else if( Input.isPressed('right') ) 
		{
			varInputFileName = varLeberName[2];
			
		}
		
		this.refresh();
		this.oldFileName = varInputFileName;
		this.drawLaber(varInputFileName);
		
	};
	
	//レバー入力
	Window_BattleLeberGauge.prototype.InputRapid = function()
	{
		if( Input.isTriggered('left') )
		{
			AudioManager.playSe({"name":varInputSe,"volume":90,"pitch":100,"pan":0})
			varLeverGtyaCount -= 1;
			//this.shakePicture(4);
			
		}
		else if ( Input.isTriggered('right') )
		{
			AudioManager.playSe({"name":varInputSe,"volume":90,"pitch":100,"pan":0})
			varLeverGtyaCount -= 1;
			//this.shakePicture(6);
		}
		
		if(varLeverGtyaCount <= 0)
		{
			$gameSwitches.setValue( varLeberSwitch, true);
			varLeverGtyaCount = 0;
			varShowLeberGageFlag = false;					//レバーゲージ非表示
			//Bgsが再生されてる時があるのでここでリセット
			AudioManager.playBgs({"name":"","volume":90,"pitch":100,"pan":0});
		}
	}
	
	//レバー更新
	Window_BattleLeberGauge.prototype.drawLaber = function(Filename)
	{
		var bitmap = ImageManager.loadPicture(Filename);
		var sx = 0;						//これはいったい？ピクチャ関連？
	    var sy = 0;						//これはいったい？
		var sw = bitmap._image.width;
		var sh = bitmap._image.height;
		var dx = varLeberOffsetX;		//レバーX座標
		var dy = varLeberOffsetY;		//レバーY座標
		
		this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy);
		
	};
	
	//連打ゲージ描画
	Window_BattleLeberGauge.prototype.drawLaberGage = function()
	{
		var color1 = varGageColor;
		var color2 = varGageFillColor;
		
		var rate = (varLeverGtyaCount / varLeverGtyaCountMax);
		if( rate < 0 )
			rate = 0;
		
		this.drawGauge(varGageX, varGageY, varGageWidth, rate, color1, color2);
	}
	
	//指定ピクチャ押下時揺れる
	//Window_BattleLeberGauge.prototype.shakePicture = function( varDirectionNo )
	//{
	//	//ピクチャ連動有効時
	//	if(isPictureInterlocking === true)
	//	{
			//向き番号で分岐
	//		switch( varDirectionNo )
	//		{
				//左動く
	//			case 4:
	//				$gameScreen.movePicture(BattleManager._picNo,0,BattleManager._picXpos - varPictureShake, BattleManager._picYpos,100,100,255,0,1);
	//			break;
				
				//右動く
	//			case 6:
	//				$gameScreen.movePicture(BattleManager._picNo,0,BattleManager._picXpos + varPictureShake, BattleManager._picYpos,100,100,255,0,1);
	//			break;
	//		}
	//	}
	//}
	
	//ゲージ描画の上書き処理
	Window_BattleLeberGauge.prototype.drawGauge = function(x, y, width, rate, color1, color2) 
	{
	    var fillW = Math.floor(width * rate);
	    var gaugeY = y + this.lineHeight() - 8;
	    
	    //this.contents.fillRect(x, gaugeY, width, 6, this.gaugeBackColor());	//オリジナル
	    this.contents.fillRect(x, gaugeY - 1, width + 2, 8, this.gaugeBackColor());
	    
	    this.contents.gradientFillRect(x + 1, gaugeY, fillW, 6, color1, color2);
	};
  //-----------------------------------------------------------------------------
  // Scene_Battle
  //
	var _Scene_Battle_createDisplayObjects = Scene_Battle.prototype.createDisplayObjects;
	Scene_Battle.prototype.createDisplayObjects = function() 
	{
		_Scene_Battle_createDisplayObjects.call(this);
		this._oldFlg = false;
		
	};
	
	// レバーウィンドウの作成
	Scene_Battle.prototype.createLeberWindow = function() 
	{
		this._leberGaugeWindow = new Window_BattleLeberGauge();
		this.addChild(this._leberGaugeWindow);
	};
	
	//バトル時の更新
	var _Scene_Battle_updateBattleProcess = Scene_Battle.prototype.updateBattleProcess;
	Scene_Battle.prototype.updateBattleProcess = function() 
	{
		_Scene_Battle_updateBattleProcess.call(this);
		this.MakeHideLeberGage();
	}
	
	//レバーゲージ表示・非表示監視
	Scene_Battle.prototype.MakeHideLeberGage = function() 
	{
		//falseになったら即破棄
		if(varShowLeberGageFlag === false)
		{
			
			//旧情報と違うとき
			if( this._oldFlg != varShowLeberGageFlag)
			{
				this.removeChild(this._leberGaugeWindow);		//破棄
				this._oldFlg = varShowLeberGageFlag;
				$gameSwitches.setValue(varLeberSwitch, false);
			}
		}
		else
		{
			//旧情報と違うとき
			if( this._oldFlg != varShowLeberGageFlag)
			{
				this.createLeberWindow();						//作成
				this._oldFlg = varShowLeberGageFlag;
			}
		}
	}
})();